unit IWCompCheckbox;
{PUBDIST}

interface

uses
  {$IFDEF VSNET}
  System.ComponentModel, System.Drawing, IWNetClasses, IWNETBaseControl,
  {$ELSE}
  Classes,
    {$IFDEF Linux}
    IWCLXComponent, IWCLXClasses,
    {$ELSE}
    IWVCLComponent, IWVCLClasses,
    {$ENDIF}
  {$ENDIF}
  IWHTMLTag,
  IWControl, IWTypes, IWScriptEvents, IWRenderContext, IWBaseInterfaces;

type
  TIWCustomCheckBoxStyle = (stNormal, stCool);

  TIWCustomCheckBox = class(TIWCustomControl, IIWInputControl, IIWSubmitControl)
  protected
    FSubmitParam : String;  
    FChecked: Boolean;
    FStyle: TIWCustomCheckBoxStyle;
    FOnChange: TNotifyEvent;
    //
    procedure HookEvents(AContext: TIWPageContext40; AScriptEvents: TIWScriptEvents); override;
    //
    procedure Submit(const AValue: string); override;
    procedure SetValue(const AValue: string); virtual;
    procedure GetInputControlNames(ANames: TStringList); override;
    function IsForThisControl(AName: string): boolean; override;
    function get_ShouldRenderTabOrder: boolean; override;
    //
    procedure SetChecked(AValue: boolean);virtual;
    function GetChecked: boolean;virtual;

    procedure InitControl; override;
    {$IFDEF VSNET}
    function getText: string; reintroduce;virtual;
    procedure setText(AValue: string); reintroduce;virtual;
    {$ENDIF}
  public
    function RenderHTML(AContext: TIWBaseHTMLComponentContext): TIWHTMLTag; override;
    function GetSubmitParam : String;
    property Checked: Boolean read GetChecked write SetChecked;
  published
    {$IFDEF VSNET}
    property Text: string read getText write setText;
    {$ELSE}
    property Caption;
    {$ENDIF}
    property Editable;
    property ExtraTagParams;
    {$IFDEF CLR}
    property WebFont;
    {$ELSE}
    property Font;
    {$ENDIF}
    property ScriptEvents;
    property DoSubmitValidation;
    property Style: TIWCustomCheckBoxStyle read FStyle write FStyle;
    property TabOrder;

    property OnClick;
    property OnChange: TNotifyEvent read FOnChange write FOnChange;

  end;

  {$IFDEF VSNET}
  {$R icons\Atozed.Intraweb.TIWCheckBox.bmp}
  TIWCheckBox = class;
  [ToolboxItem(true), ToolboxBitmap(typeof(TIWCheckBox), 'TIWCheckBox.bmp')]
  {$ENDIF}
  TIWCheckBox = class(TIWCustomCheckBox)
  published
    property Confirmation;
    {$IFDEF VSNET}
    [Bindable(true)]
    {$ENDIF}
    property Checked;
    property Enabled;
    property FriendlyName;
  end;

implementation

uses
  SysUtils,
  {$IFDEF Linux}QGraphics,{$ELSE}Graphics,{$ENDIF}
  IWAppForm, IWServer,
  SWSystem, IWBaseForm, IWForm, IWMarkupLanguageTag;

function TIWCustomCheckBox.GetSubmitParam: String;
begin
  Result := FSubmitParam;
end;

function TIWCustomCheckBox.get_ShouldRenderTabOrder: boolean;
begin
  Result := False;
end;


function TIWCustomCheckBox.RenderHTML(AContext: TIWBaseHTMLComponentContext): TIWHTMLTag;
begin
  // Div is a must here becouse the HTML is constructed by TAG + Caption or 2 TAGS
  Result := TIWHTMLTag.CreateTag('SPAN'); try
    Result.AddStringParam('ID', HTMLName);
    if (Style = stNormal) then begin
      with Result.Contents.AddTag('INPUT') do begin
        if TabOrderInterface(Self).HasTabOrder then begin
          AddStringParam('TabIndex', IntToStr(TabOrderInterface(Self).RealTabOrder + 1));
        end;

        Add(iif(not Enabled, 'DISABLED'));
        if Editable then begin
          AddStringParam('TYPE', 'CHECKBOX');
          Add(iif(FChecked, 'CHECKED'));
          AddStringParam('NAME', HTMLName + '_CHECKBOX');
          // AddStringParam('ID', HTMLName + '_CHECKBOX');
        end else begin
          AddStringParam('TYPE', 'CHECKBOX');
          Add(iif(FChecked, 'CHECKED'));
          if not IsDesignMode then begin
            AddStringParam('OnClick', 'return false;');
          end;
        end;
      end;
      with Result.Contents.AddTag('SPAN') do begin
        if Editable and Enabled then begin
          AddStringParam('OnClick', 'FindElem('''+HTMLName + '_CHECKBOX'').checked = !FindElem(''' + HTMLName + '_CHECKBOX'').checked;');
        end;
        Contents.AddText(Caption);
      end;
    end else begin
      if Editable then begin
        with TIWComponent40Context(AContext) do begin
          CacheImage('CoolCheckBox_False', WebApplication.InternalURLBase
           + '/gfx/CoolCheckBox_False.gif');
          CacheImage('CoolCheckBox_True', WebApplication.InternalURLBase
           + '/gfx/CoolCheckBox_True.gif');
          if WebApplication.IsPartialUpdate then begin
            AddToUpdateInitProc('IWTop().document.images.' + HTMLName + '_Image.src'
             + '=IWTop().GImageCache_CoolCheckBox_' + iif(FChecked, 'True', 'False') + '.src;' + EOL
             + 'IWTop().FindElem(''' + HTMLName + '_CHECKBOX'').value="' + iif(FChecked, 'On', 'Off')
             + '";' + EOL);
          end else begin
            AddToInitProc('document.images.' + HTMLName + '_Image.src'
             + '=GImageCache_CoolCheckBox_' + iif(FChecked, 'True', 'False') + '.src;' + EOL
             + 'IWTop().FindElem(''' + HTMLName + '_CHECKBOX'').value="' + iif(FChecked, 'On', 'Off')
             + '";' + EOL);
          end;
        end;
        //TODO: Use a TIWHTMLImage
        with Result.Contents.AddTag('A') do begin
          AddStringParam('HREF', '#');

          // fix: removes unwanted underlining between the image and the caption
          AddStringParam('style', 'text-decoration:none' );

          // TODO: Fix for .NET
          AddStringParam('OnClick'
            , 'CoolCheckBoxToggle(''' + HTMLName + '_CHECKBOX'', ' + 'document.images.' + HTMLName
            + '_Image, ' + iif(hasOnClick, 'true', 'false') + ')');
          with Contents.AddTag('IMG') do begin
            AddStringParam('NAME', HTMLName + '_Image');
            AddIntegerParam('BORDER', 0);
            // Width and height tags necessary for NS4, good for others
            AddIntegerParam('WIDTH', 10);
            AddIntegerParam('HEIGHT', 12);
          end;
        end;
        with Result.Contents.AddTag('INPUT') do begin
          AddStringParam('TYPE', 'HIDDEN');
          AddStringParam('NAME', HTMLName + '_CHECKBOX');
          // AddStringParam('ID', HTMLName + '_CHECKBOX');
        end;
      end else begin
        //TODO: Use a TIWHTMLImage
        with Result.Contents.AddTag('IMG') do begin
          AddStringParam('SRC', AContext.WebApplication.InternalURLBase + '/gfx/CoolCheckBox_' + iif(FChecked, 'True', 'False') + '.gif');
          AddIntegerParam('BORDER', 0);
          // Width and height tags necessary for NS4, good for others
          AddIntegerParam('WIDTH', 10);
          AddIntegerParam('HEIGHT', 12);
        end;
      end;
      with Result.Contents.AddTag('SPAN') do begin
        if Editable and Enabled then begin
          AddStringParam('OnClick'
            , 'CoolCheckBoxToggle(''' + HTMLName + '_CHECKBOX'', ' + 'document.images.' + HTMLName
            + '_Image, ' + iif(hasOnClick, 'true', 'false') + ')');
        end;
        Contents.AddText(Caption);
      end;
    end;
  except FreeAndNil(Result); raise; end;
end;

procedure TIWCustomCheckBox.SetValue(const AValue: string);
var
  LIsChecked : boolean;
begin
  if RequiresUpdateNotification(Parent) then begin
    UpdateNotifiedInterface(Parent).NotifyUpdate(Self,AValue);
  end;
  LIsChecked := AnsiSameText(AValue, 'On');
  if Checked <> LIsChecked then begin
    Checked := LIsChecked;
    Invalidate;
    if Assigned(OnChange) then begin
      OnChange(Self);
    end;
  end;
end;

procedure TIWCustomCheckBox.Submit(const AValue: string);
begin
  FSubmitParam := AValue;
  DoClick;
end;

procedure TIWCustomCheckBox.SetChecked(AValue: boolean);
begin
  FChecked := AValue;
  Invalidate;
end;

function TIWCustomCheckBox.GetChecked: boolean;
begin
  Result:= FChecked
end;

procedure TIWCustomCheckBox.InitControl;
begin
  inherited;
  FNeedsFormTag := True;
  Height := 21;
  Width := 121;
  FCanReceiveFocus := True;
end;

procedure TIWCustomCheckBox.HookEvents(AContext: TIWPageContext40; AScriptEvents: TIWScriptEvents);
begin
  inherited HookEvents(AContext, AScriptEvents);
  if (Style = stNormal) and Editable then begin
    AScriptEvents.HookEvent('OnClick', iif(hasOnClick, SubmitHandler('')));
  end;
end;

procedure TIWCustomCheckBox.GetInputControlNames(ANames: TStringList);
begin
  ANames.Add(HTMLName + '_CHECKBOX');
end;

function TIWCustomCheckBox.IsForThisControl(AName: string): boolean;
begin
  result := HTMLName + '_CHECKBOX' = AName;
end;

{$IFDEF VSNET}
function TIWCustomCheckBox.getText: string;
begin
  Result := Caption;
end;

procedure TIWCustomCheckBox.setText(AValue: string); 
begin
  Caption := AValue;
  TIWNETBaseControl(Self).Invalidate;
end;
{$ENDIF}

initialization
  TIWServer.AddInternalFile('IW_GFX_CoolCheckBox_False', '/gfx/CoolCheckBox_False.gif');
  TIWServer.AddInternalFile('IW_GFX_CoolCheckBox_True', '/gfx/CoolCheckBox_True.gif');
end.
